import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;
import java.sql.*;

public class Spielebene extends JPanel implements ActionListener {

    private final int B_BREITE = 400;
    private final int B_HOEHE = 400;
    private final int PUNKT_GROESSE = 10;
    private final int MOEGL_PKTE = 900;
    private final int ZUFALLS_POS = 29;
    private final int VERZOEGERUNG = 90;

    private final int x[] = new int[MOEGL_PKTE ];
    private final int y[] = new int[MOEGL_PKTE ];
    
    private TAdapter taste;
    
    private static String username;
    
    private int punkte;
    private int gruen_x;
    private int gruen_y;
    private int highScore;
    private int liveScore;

    private boolean links = false;
    private boolean rechts = true;
    private boolean hoch = false;
    private boolean runter = false;
    private boolean spielAktiv = true;
    private boolean idiot = false;

    private Timer timer;
    private Image gruen;
    private Image rot;
    private Image schwarz;
    private Image kopf;

    public Spielebene() {
        
        initBoard();
    }
    
    private void initBoard() {

        addKeyListener(new TAdapter());
        setBackground(Color.black);
        setFocusable(true);

        setPreferredSize(new Dimension(B_BREITE, B_HOEHE));
        ladeBilder();
        starteSpiel();
    }

    private void ladeBilder() {

        ImageIcon iid = new ImageIcon("gruen.png");
        gruen = iid.getImage();

        ImageIcon iih = new ImageIcon("rot.png");
        rot = iih.getImage();
        
        ImageIcon iig = new ImageIcon("schwarz.png");
        schwarz = iig.getImage();
        
        ImageIcon iij = new ImageIcon("kopf.png");
        kopf = iij.getImage();
    }
    
    public static void nutzernameUebergeben(String n){
        username = n;
    }
    
    private void highscoreSpeichern(){
        liveScore = liveScore - 1;
            if (highScore < liveScore) {
           highScore = liveScore;
           System.out.println("High Score: " + highScore);
           mysql.übergeben(username, highScore);
        }
        liveScore = 0;
    }
    
    private void starteStartbildschirm(){
        
    }
    
    private void starteSpiel() {

        punkte = 1;

        for (int z = 0; z < punkte; z++) {
            x[z] = 50 - z * 10;
            y[z] = 50;
        }
        
        setzeGruen();
        
        runter = false;
        rechts = true;
        links = false;
        hoch = false;

        timer = new Timer(VERZOEGERUNG, this);
        timer.start();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);

        zeichneEbene(g);
    }
    
    private void zeichneEbene(Graphics g) {
        
        if (spielAktiv) {

            g.drawImage(gruen, gruen_x, gruen_y, this);

            for (int z = 0; z < punkte; z++) {
                if (z == 0) {
                    g.drawImage(kopf, x[z], y[z], this);
                } else if (z < 100) {
                    g.drawImage(rot, x[z], y[z], this);
                }
                else{
                    gameWin(g);
                }
            }

        } else {
            gameOver(g);
        }        
    }
    
    private void gameWin(Graphics g) {
        timer.stop();
        
        String vorbei = "Spiel gewonnen";
        Font small = new Font("Helvetica", Font.BOLD, 14);
        FontMetrics metr = getFontMetrics(small);
        
        g.drawImage(schwarz, 0, 0, this);
        g.setColor(Color.yellow);
        g.setFont(small);
        g.drawString(vorbei, (B_BREITE - metr.stringWidth(vorbei)) / 2, B_HOEHE / 2);
        highscoreSpeichern();
    }
    
    private void gameOver(Graphics g){
        String vorbei = "Spiel beendet";
        Font small = new Font("Helvetica", Font.BOLD, 14);
        FontMetrics metr = getFontMetrics(small);
        
        g.setColor(Color.white);
        g.setFont(small);
        g.drawString(vorbei, (B_BREITE - metr.stringWidth(vorbei)) / 2, B_HOEHE / 2);
        spielAktiv = true;
        highscoreSpeichern();
    }

    private void pruefeGruen() {

        if ((x[0] == gruen_x) && (y[0] == gruen_y)) {
            
            punkte++;
            setzeGruen();
        }
    }

    private void bewegen() {

        for (int z = punkte; z > 0; z--) {
            x[z] = x[(z - 1)];
            y[z] = y[(z - 1)];
        }

        if (links) {
            x[0] -= PUNKT_GROESSE;
        }

        if (rechts) {
            x[0] += PUNKT_GROESSE;
        }

        if (hoch) {
            y[0] -= PUNKT_GROESSE;
        }

        if (runter) {
            y[0] += PUNKT_GROESSE;
        }
    }

    private void pruefeKollision() {

        for (int z = punkte; z > 0; z--) {

            if ((z > 4) && (x[0] == x[z]) && (y[0] == y[z])) {
                spielAktiv = false;
            }
        }

        if (y[0] >= B_BREITE-45) {
            spielAktiv = false;
        }

        if (y[0] < 0) {
            spielAktiv = false;
        }

        if (x[0] >= B_HOEHE-20) {
            spielAktiv = false;
        }

        if (x[0] < 0) {
            spielAktiv = false;
        }
        
        if (!spielAktiv) {
            timer.stop();
        }
        
    }

    private void setzeGruen() {

        liveScore = liveScore + 1;
        
        int r = (int) (Math.random() * ZUFALLS_POS);
        gruen_x = ((r * PUNKT_GROESSE));

        r = (int) (Math.random() * ZUFALLS_POS);
        gruen_y = ((r * PUNKT_GROESSE));
    }

    @Override
    public void actionPerformed(ActionEvent e) {

        if (spielAktiv) {

            pruefeGruen();
            pruefeKollision();
            bewegen();
        }

        repaint();
    }
    
    public void falscheTaste(){//(Graphics g){
        if (idiot){
        //   String idiotisch = "falsche Taste";
        //   Font small = new Font("Helvetica", Font.BOLD, 14);
        //   FontMetrics metr = getFontMetrics(small);
        System.out.println("falsche Taste");
        //   g.setColor(Color.red);
        //   g.setFont(small);
        //   g.drawString(idiotisch, (B_BREITE - metr.stringWidth(idiotisch)) / 2, B_HOEHE / 2);
           idiot = false;
        }
    }
    
    private class TAdapter extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {

            int key = e.getKeyCode();

            if ((key == KeyEvent.VK_DOWN)) {
                if (hoch == true){
                    idiot = true;
                }
                else{
                runter = true;
                rechts = false;
                links = false;
                hoch = false;
                }
            }
            else if ((key == KeyEvent.VK_RIGHT)) {
                if (links == true){
                    idiot = true;
                }
                else{
                runter = false;
                rechts = true;
                links = false;
                hoch = false;
                }
            }
            else if ((key == KeyEvent.VK_LEFT)) {
                if (rechts == true){
                    idiot = true;
                }
                else {
                runter = false;
                rechts = false;
                links = true;
                hoch = false;
                }
            }
            else if ((key == KeyEvent.VK_UP)) {
                if (runter == true){
                    idiot = true;
                }
                else{
                runter = false;
                rechts = false;
                links = false;
                hoch = true;
                }
            }
            else if ((key == KeyEvent.VK_ENTER)){
                timer.stop();
                starteSpiel();
            } else{
                idiot = true;
            }
        }
    }
}